@extends('layouts.default')
@section('conteudo')
<div>
    <h5>
        Pagamentos realizados
        
        <a href="{{url('')}}" class="material-icons float-right" style="font-size: 1.3em; color: #333;">
        keyboard_backspace
        </a>
    </h5>
    <hr>
        
    <div class="row mb-2">
        <div class="col-6 col-md-4">
            <label for="">Mês: </label>
            <select name="mes" id="mes" class="form-control" onchange="changeMes()">
                @foreach(todosMeses() as $i => $m)
                    <option {{ $mes == $i ? 'selected' : '' }} value="{{$i}}">{{$m}}</option>
                @endforeach
            </select>
        </div>
        <div class="col-6 col-md-4">
            <label for="">Ano: </label>
            <select name="ano" id="ano" class="form-control" onchange="changeMes()">
                <?php 
                $anos = [
                    date('Y'),
                    date('Y')+1
                ];
                ?>
                @foreach($anos as $a)
                    <option {{ $ano == $a ? 'selected' : '' }} value="{{$a}}">{{$a}}</option>
                @endforeach
            </select>
        </div>
    </div>
    <br>

    <div class="row">
        <div class="col-md-12">
            @if($pagamentos->count())
                <?php $total = 0; ?>
                <table class="table table-hover table-sm" width="100%">
                    <thead>
                        <tr class="btn-parque">
                            <th>Ref.</th>
                            <th>Cliente</th>
                            <th>Dependentes</th>
                            <th>Vencimento</th>
                            <th>Cobrado</th>
                            <th>Pago</th>
                        </tr>
                    </thead>
                    @foreach($pagamentos as $pagamento)
                        <tr>
                            <td>{{$pagamento->mes_ref}}/{{$pagamento->ano_ref}}</td>
                            <td>{{$pagamento->cliente}}</td>
                            <td>{{$pagamento->dependentes}}</td>
                            <td>{{date('d/m/Y', strtotime($pagamento->dt_vencimento))}}</td>
                            <td>{{number_format($pagamento->valor_total_cobranca, 2, ',', '.')}}</td>
                            <td>{{number_format($pagamento->valor_pago, 2, ',', '.')}}</td>
                        </tr>
                        <?php $total += $pagamento->valor_pago; ?>
                    @endforeach    
                </table>

                <div class="float-right" style="font-size: 1.5em;">
                    <b>Total R$ {{ number_format($total, 2, ',', '.') }}</b>
                </div>
            @else
                <div class="alert alert-info mt-3">Nenhum registro de pagamento encontrado</div>
            @endif
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    function changeMes() {
        var mes = document.getElementById('mes').value;
        var ano = document.getElementById('ano').value;
        window.location = BASE_URL+'financeiro/relatorio-pagamentos?mes='+mes+'&ano='+ano;
    }
</script>
@endsection

